//
//  MCTouchSyncGlobals.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 24/03/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>


#define SYNC_PROTOCOL_MAJOR_VERSION 1
#define SYNC_PROTOCOL_MINOR_VERSION 3

// URL constants
extern NSString *kMCProtocolURLScheme;

// User defaults keys
extern NSString *kMCHostnameDefaultsKey;
extern NSString *kMCDatabaseDefaultsKey;
extern NSString *kMCAlwaysRunStageSyncDefaultsKey;
extern NSString *kMCInternetHostnameDefaultsKey;
extern NSString *kMCInternetPortNumberDefaultsKey;
extern NSString *kMCEnabledUPnPSupportDefaultsKey;
extern NSString *kMCProcessStateLogLevelDefaultsKey;


// File and Folder constants
extern NSString *kMCServerStageFolderName;
extern NSString *kMCServerTouchKeychainFileName;
extern NSString *kMCDeviceMirrorName;
extern NSString *kMCStageSettingsFileName;
extern NSString *kMCSyncProtocolFileName;
extern NSString *kMCSyncProtocolFileType;


// Distributed Notification constants
extern NSString *kMCTouchServerCompleteNotificationName;

extern NSString *kMCStageSyncInitStartedNotificationName;
extern NSString *kMCStageSyncInitProgressNotificationName;
extern NSString *kMCStageSyncCompleteNotificationName;
extern NSString *kMCTaskDescriptionKey;
extern NSString *kMCInitDatabaseEstimatedStepsKey; // An int with the number of expected steps in the init progress


// Sync Settings Dictionary keys (see also login request and db init keys)
extern NSString *kMCServerUUIDKey;
extern NSString *kMCEventTrackingDeviceIDKey;
extern NSString *kMCClientLastSyncDateKey;
extern NSString *kMCVerifyKey;
extern NSString *kMCVerifyAgainstNewStageKey;
extern NSString *kMCUserDisplayNameKey;
extern NSString *kMCSyncOptionsKey;
extern NSString *kMCResetOnNextClientSyncKey; // boolean


// Sync Settings User Defaults keys
extern NSString *kMCOrganizationTouchSyncListIDKey;
extern NSString *kMCContactTouchSyncListIDKey;


//
// Sync Protocol payload dictionary keys
//

// kMCLoginRequest keys
extern NSString *kMCClientUUIDKey; // string
extern NSString *kMCUsernameKey; // string
extern NSString *kMCPasswordKey; // string
extern NSString *kMCDeviceNameKey; // string
extern NSString *kMCDeviceModelKey; // string
extern NSString *kMCClientReplicationOffsetKey; // string
extern NSString *kMCSyncProtocolMajorVersionKey; // number
extern NSString *kMCSyncProtocolMinorVersionKey; // number
extern NSString *kMCCloudAccountKey; // string
extern NSString *kMCLastKnownDeviceSyncIdentifier; // string
extern NSString *kMCLastKnownServerChangeLogID; // number

enum {
	kMCLoginResultUndefined = 0, // illegal value
	kMCLoginResultSuccess = 1,

	kMCLoginResultFailureMissingClientID = 3,
	kMCLoginResultFailureInvalidServerID = 4,
	kMCLoginResultFailureClientWipe = 5,
	kMCLoginResultFailureServerError = 6,
	kMCLoginResultFailureInvalidCredentials = 7,
	kMCLoginResultFailureClientStageBusy = 8,
	kMCLoginResultFailureRestricted = 9,
	kMCLoginResultFailureProtocolMismatch = 10,
	kMCLoginResultFailureLicensesExceeded = 11,
    kMCLoginResultFailureTrialExpired = 12,
    kMCLoginResultFailureLicenseExpired = 13,
    
	kMCLoginResultDatabaseResetSendChanges = 16,
	kMCLoginResultDatabaseResetDiscardChanges = 17,
    
    
    // added to match MCSAuthenticationResultCode -- silly that these are different
    kMCLoginResultConnectionFailed = 26,
    kMCLoginResultServiceTemporarilyUnavailable = 214,
    kMCLoginResultAccountTemporarilyUnavailable = 215,
    kMCLoginResultAccountRequiresUserAction = 216,
    kMCLoginResultDeviceReplicaLocked = 217,
    kMCLoginResultDeviceSyncStateMismatch = 218,
};

typedef NSUInteger MCLoginResult;

typedef enum {
	kMCSLicenseTypeTrial = 1,
	kMCSLicenseTypeNormal
} MCSLicenseType;


// kMCLoginResponse
extern NSString *kMCLoginResultKey;
extern NSString *kMCServerSupportsReplicationOffsetLoginKey;
extern NSString *kMCRemoteWipeKey;
extern NSString *kMCPersistentSyncServerKey; // optional string - the persistent server to sync with in the future
extern NSString *kMCCountOfContactsKey;
extern NSString *kMCCountOfOrganizationsKey;
extern NSString *kMCExpiryIntervalKey; // Number - timeIntervalSince1970
extern NSString *kMCLicenseTypeKey; // NSNumber - MCLicenseType
extern NSString *kMCCloudAccountNameKey;
extern NSString *kMCIsHostedAccountKey;

// kMCInitDatabaseRequest
extern NSString *kMCDatabaseRequiresInitKey; // boolean
extern NSString *kMCUseSyncListKey; // boolean

enum {
	kMCInitDatabaseResultUndefined = 0, // illegal value
	kMCInitDatabaseResultDownloadReady = 1,
	kMCInitDatabaseResultFailure
};

typedef unsigned long MCInitDatabaseResult;


// kMCInitDatabaseResponse
extern NSString *kMCInitDatabaseResultKey;    // A MCInitDatabaseResult
extern NSString *kMCInitDatabaseProgressKey;  // A float with the current progress initializing the database

// kMCFileTransferPrefix
extern NSString *kMCFileTransferSizeKey;
extern NSString *kMCFileHashKey;
extern NSString *kMCFileIsCompressedKey;

// kMCFileTransferOffset
extern NSString *kMCFileOffsetStartKey;

// kMCFileTransferContent
extern NSString *kMCFileBytesChunkKey;

// kMCFileTransferResult
extern NSString *kMCFileTransferResultKey;

// Sync Protocol message names
extern NSString *kMCSyncServerReady;

extern NSString *kMCLoginRequest; // Payload includes username, password, device ID, device name
extern NSString *kMCLoginResponse; // Payload contains a result code
extern NSString *kMCInitDatabaseRequest; // Payload contains the categories selected by the user
extern NSString *kMCInitDatabaseResponse; // Payload contains progress and a flag inidicating if the database is ready
extern NSString *kMCSyncUpRequest; // No payload
extern NSString *kMCSyncDownRequest; // No payload
extern NSString *kMCLogoutRequest; // No payload

// File transfer message names
extern NSString *kMCFileTransferPrefix;  // Payload includes length of compressed file and hash of uncompressed file
extern NSString *kMCFileTransferOffset;  // Payload includes byte offset to start from
extern NSString *kMCFileTransferChunk;   // Payload includes chunk of bytes up to the maximum chunk size
extern NSString *kMCFileTransferComplete; // No payload
extern NSString *kMCFileTransferResult;  // Payload is a boolean result code


// Exceptions
extern NSString *MCSQLiteErrorException; // if there is an error with SQLite
